/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-05-25
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "GridParallelWriter.h"

namespace QGpCoreMath {

  /*!
    \class GridParallelWriter GridParallelWriter.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  GridParallelWriter::GridParallelWriter(IrregularGrid2D * grid)
  {
    TRACE;
    _grid=grid;
    _locks=nullptr;
    _lockCount=0;
  }

  /*!
    Description of destructor still missing
  */
  GridParallelWriter::~GridParallelWriter()
  {
    TRACE;
    for(int i=0; i<_lockCount; i++) {
      if(_locks[i].tryLock()) {
        _locks[i].unlock();
      } else {
        ASSERT(false);
      }
    }
    delete [] _locks;
  }

  /*!
    Select row mode. Either this function or lockColumns() must be used.
  */
  void GridParallelWriter::lockRows()
  {
    TRACE;
    _lockCount=_grid->ny();
    ASSERT(_lockCount>0);
    delete [] _locks;
    _locks=new QMutex[_lockCount];
  }

  /*!
    Select column mode. Either this function or lockRows() must be used.
  */
  void GridParallelWriter::lockColumns()
  {
    TRACE;
    _lockCount=_grid->nx();
    ASSERT(_lockCount>0);
    delete [] _locks;
    _locks=new QMutex[_lockCount];
  }

  /*!
    \fn GridParallelWriter::lockRow(int index)

    Lock row \a index and return a pointer to its values.
    Values can accessed with an increment of sizeof(double)
  */

  /*!
    \fn GridParallelWriter::lockColumn(int index)

    Lock column \a index and return a pointer to its values.
    Values can accessed with an increment of ny*sizeof(double)
  */

} // namespace QGpCoreMath

