/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-19
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ComplexPointOptions.h"

namespace QGpCoreMath {

  /*!
    \class ComplexPointOptions ComplexPointOptions.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
  */
  double ComplexPointOptions::toDouble(double, const Complex& c) const
  {
    switch(_mode) {
    case AbsoluteValue:
      break;
    case Phase:
      return c.phase();
    case Real:
      return c.re();
    case Imaginary:
      return c.im();
    }
    return c.abs();
  }


  /*!
  */
  void ComplexPointOptions::fromDouble(double, Complex& c, double v) const
  {
    switch(_mode) {
    case AbsoluteValue:
      c.setAbs(v);
      break;
    case Phase:
      c.setPhase(v);
      break;
    case Real:
      c.setRe(v);
      break;
    case Imaginary:
      c.setIm(v);
      break;
    }
  }

} // namespace QGpCoreMath
