/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-01-04
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ANGLESEARCH_H
#define ANGLESEARCH_H

#include "FunctionSearch.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT AngleSearch : public FunctionSearch
  {
  public:
    AngleSearch();
    ~AngleSearch();

    void setGrid(int stepCount);

    double value(int index) const {return FunctionSearch::value(_angles[index], index);}

    virtual void globalMax(double absThres);
    virtual void localMax(int nMax, double absThres, double relThres);
  private:
    double refineMax(const double& min, const double& max, double maxVal);
    inline void checkForMax(double angle, double& maxVal);
    inline void refineMax(int k, double maxVal);

    int _n;
    double * _angles;
  };

} // namespace QGpCoreMath

#endif // ANGLESEARCH_H

