/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-29
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef STATIONPEAKMODEL_H
#define STATIONPEAKMODEL_H

#include <HVCore.h>

#include "AbstractPeakModel.h"
#include "HVGuiDLLExport.h"

namespace HVGui {

  class HVGUI_EXPORT StationPeakModel : public AbstractPeakModel
  {
  public:
    StationPeakModel(const QList<CurveResults *>& results, QObject * parent=nullptr);
    ~StationPeakModel();

    const QList<CurveResults *>& results() const {return _res;}
    CurveResults * results(int index);

    void add(double min, double max);
    void adjust(int index, double min, double max);
    void remove(int index);
    void save(QTextStream& s, int index);

    int rowCount(const QModelIndex &parent=QModelIndex()) const;
    int columnCount(const QModelIndex &parent=QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    QVariant headerData(int section, Qt::Orientation orientation, int role=Qt::DisplayRole) const;
  private:
    void reset();

    QList<CurveResults *> _res;
    struct Peak
    {
      CurveResults * _results;
      int _index;
    };
    QList<Peak *> _peaks;
  };

} // namespace HVGui

#endif // STATIONPEAKMODEL_H
