/***************************************************************************
**
**  This file is part of HVCore.
**
**  HVCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-02-18
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HVWORKER_H
#define HVWORKER_H

#include <GeopsyCore.h>

#include "HVCoreDLLExport.h"
#include "HVTaskManager.h"

namespace HVCore {

  class HVCORE_EXPORT HVWorker : public TaskWorker
  {
  public:
    HVWorker();
    ~HVWorker();

    void setTaskManager(HVTaskManager * tm) {TaskWorker::setTaskManager(tm);}
  protected:
    HVTaskManager * taskManager() {return static_cast<HVTaskManager *>(TaskWorker::taskManager());}

    void process(AbstractTask * t);
  private:
    StationProcessSignals * _signals;
  };

} // namespace HVCore

#endif // HVWORKER_H

