/***************************************************************************
**
**  This file is part of HVCore.
**
**  HVCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-05-25
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTRESULTS_H
#define ABSTRACTRESULTS_H

#include <GeopsyCore.h>

#include "HVCoreDLLExport.h"

namespace HVCore {

  class AbstractStation;
  class HVParameters;

  class HVCORE_EXPORT AbstractResults : public QObject
  {
    Q_OBJECT
  public:
    AbstractResults(AbstractStation * parent);
    ~AbstractResults();

    AbstractStation * parent() const;

    virtual void clear()=0;
    virtual void setWindows(int winCount, const HVParameters& param)=0;
    virtual void setWindow(int winIndex, double winLength, const Curve<Point2D>& curve)=0;
    virtual int windowCount() const=0;
    virtual void setWindowColor(int winIndex, const Color& col);
    virtual void setWindowColor(const QVector<int>* selCurves, const Color& col);
    virtual void setStatistics();
    virtual void setPeaks();
    virtual QString comments() const {return QString();}

    virtual double maximumAmplitude() const=0;
    virtual bool save(QString fileName, QString log) const=0;

    const QString& category() const {return _category;}
    void setCategory(const QString& c) {_category=c;}

    const QString& name() const {return _name;}
    void setName(const QString& n) {_name=n;}

    const Point& coordinates() const {return _coordinates;}
    void setCoordinates(const Point& p) {_coordinates=p;}

    QString unit() const;

    const SamplingParameters& frequencySampling() const {return _sampling;}
  protected:
    void setFrequencySampling(const SamplingParameters& s) {_sampling=s;}
  private:
    SamplingParameters _sampling;
    QString _category;
    QString _name;
    Point _coordinates;
  };

} // namespace HVCore

#endif // ABSTRACTRESULTS_H

