/***************************************************************************
**
**  This file is part of GeopsySLinkGui.
**
**  GeopsySLinkGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsySLinkGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-05-03
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <GeopsySLink.h>
#include "SeedLinkLoaderOptions.h"

namespace GeopsySLinkGui {

/*!
  \class SeedLinkLoaderOptions SeedLinkLoaderOptions.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
SeedLinkLoaderOptions::SeedLinkLoaderOptions(QWidget * parent)
    : Dialog(parent)
{
  TRACE;
  setupUi(this);

  connect (fromNowBut, SIGNAL(toggled(bool)), this, SLOT(fromTimeToggled()));
  connect (fromBut, SIGNAL(toggled(bool)), this, SLOT(fromTimeToggled()));
  connect (unlimitedBut, SIGNAL(toggled(bool)), this, SLOT(bufferToggled()));
  connect (createNewBut, SIGNAL(toggled(bool)), this, SLOT(bufferToggled()));
  connect (rotateBut, SIGNAL(toggled(bool)), this, SLOT(bufferToggled()));
}

void SeedLinkLoaderOptions::updateAllFields()
{
  TRACE;
  bufferToggled();
  fromTimeToggled();
  on_maxDurationUnit_activated(maxDurationUnit->currentIndex());
}

void SeedLinkLoaderOptions::restore(SeedLink * sl)
{
  TRACE;
  static const char * dateFormat="dd/MM/yyyy hh:mm:ss";

  QSettings& reg=CoreApplication::instance()->settings();
  reg.beginGroup("DialogOptions");
  reg.beginGroup("SeedLinkLoaderOptions");

  if(reg.value("fromBox/fromNowBut", true).toBool()) sl->setFromTime(QDateTime());
  else {
    QString d=reg.value("fromBox/fromTime", QDateTime::currentDateTime().toString(dateFormat)).toString();
    sl->setFromTime(QDateTime::fromString(d, dateFormat) );
  }

  if(reg.value("bufferBox/unlimitedBut", true).toBool()) sl->setBufferType(SeedLinkStream::Unlimited);
  else if(reg.value("bufferBox/createNewBut", false).toBool()) sl->setBufferType(SeedLinkStream::CreateNew);
  else sl->setBufferType(SeedLinkStream::Rotate);

  double fac=unitFactor(reg.value("bufferBox/maxDurationUnit", 2).toInt());
  // DoubleSpinBox has three values in settings: nDecimals, singleStep, currentValue
  QStringList spinBoxProp=reg.value("bufferBox/maxDuration", "2,1,1").toStringList();
  if(spinBoxProp.count()==3) {
    sl->setMaximumDuration(spinBoxProp[2].toDouble() * fac);
  } else {
    sl->setMaximumDuration(fac);
  }
}

void SeedLinkLoaderOptions::getParam(SeedLink * sl)
{
  TRACE;
  if(fromNowBut->isChecked()) sl->setFromTime(QDateTime());
  else sl->setFromTime(fromTime->dateTime());

  if(unlimitedBut->isChecked()) sl->setBufferType(SeedLinkStream::Unlimited);
  else if(createNewBut->isChecked()) sl->setBufferType(SeedLinkStream::CreateNew);
  else sl->setBufferType(SeedLinkStream::Rotate);

  double fac=unitFactor(maxDurationUnit->currentIndex());
  sl->setMaximumDuration(maxDuration->value() * fac);
}

void SeedLinkLoaderOptions::bufferToggled()
{
  TRACE;
  bool c=! unlimitedBut->isChecked();
  maxDurationLabel->setEnabled(c);
  maxDuration->setEnabled(c);
  maxDurationUnit->setEnabled(c);
}

void SeedLinkLoaderOptions::fromTimeToggled()
{
  TRACE;
  fromTime->setEnabled(fromBut->isChecked());
}

void SeedLinkLoaderOptions::on_maxDurationUnit_activated(int index)
{
  TRACE;
  switch (index) {
  case 3:
    maxDuration->setSuffix(tr(" day(s)"));
    break;
  case 2:
    maxDuration->setSuffix(tr(" h"));
    break;
  case 1:
    maxDuration->setSuffix(tr(" min"));
    break;
  default:
    maxDuration->setSuffix(tr(" s"));
    break;
  }
}

double SeedLinkLoaderOptions::unitFactor(int index)
{
  TRACE;
  switch (index) {
  case 3:
    return 86400.0;
  case 2:
    return 3600.0;
  case 1:
    return 60.0;
  default:
    return 1.0;
  }
}

} // namespace GeopsySLinkGui
