#ifndef GEOPSYSLINKDLLEXPORT_H
#define GEOPSYSLINKDLLEXPORT_H

/* *_STATIC and MAKE_*_DLL are defined by the capitalization of
  the package name, included in the compiler options (only for Windows).
  Use directly WIN32 to allow transparent usage with or without Qt.
  GeopsySLinkStatic.h may contain GEOPSYSLINK_STATIC macro definition.
  This define was introduced there to mark this library as static for
  all projects that link to this library.
*/

#include "GeopsySLinkStatic.h"

#if defined(WIN32) && !defined(GEOPSYSLINK_STATIC)
#ifdef MAKE_GEOPSYSLINK_DLL
# define GEOPSYSLINK_EXPORT __declspec(dllexport)
#else
# define GEOPSYSLINK_EXPORT __declspec(dllimport)
#endif
#else
# define GEOPSYSLINK_EXPORT
#endif

#endif  // GEOPSYSLINKDLLEXPORT_H

