/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-20
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PICKTOPICK_H
#define PICKTOPICK_H

#include <QGpGuiTools.h>
#include <GeopsyCore.h>

#include "ui_PickToPick.h"
#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class GEOPSYGUI_EXPORT PickToPick : public Dialog, private Ui::PickToPick
{
  Q_OBJECT
public:
  PickToPick(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);

  void lockPickNames();

  QString pickName() const {return pickNameCombo->currentText();}
  bool magnifier() const {return showMagnifier->isChecked();}
  int context() const {return contextSize->value();}
  double time() const {return displayTime->value();}
};

} // namespace GeopsyGui

#endif // PICKTOPICK_H
