/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-06-09
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef CHRONOGRAMLAYER_H
#define CHRONOGRAMLAYER_H

#include <GeopsyCore.h>
#include <SciFigs.h>

#include "GeopsyGuiDLLExport.h"

#define CHRONOGRAMLAYER_TRACKING_ID 347

namespace GeopsyGui {

class GEOPSYGUI_EXPORT ChronogramLayer : public GraphContentLayer
{
  Q_OBJECT
public:
  ChronogramLayer(AxisWindow * parent=nullptr);
  ~ChronogramLayer();

  virtual const QString& xml_tagName() const {return xmlChronogramLayerTag;}
  static const QString xmlChronogramLayerTag;

  void subPoolUpdate(SubSignalPool * subPool=nullptr);
  void rangeUpdate();

  const SubSignalPool * subPool() const {return _subPool;}

  virtual Rect boundingRect() const;

  int hitCount() const {return _stations.count()*_stations.nComponents();}
  QString name(int index) const;

  virtual bool hasProperties() {return true;}
  virtual void addProperties(PropertyProxy * pp);
  virtual void removeProperties(PropertyProxy * pp);
  virtual void properties(PropertyWidget * w) const;
  virtual void setProperty(uint wid, int pid, QVariant val);

  void exportGaps(const QString& fileName);

  virtual bool trackRectangle(int id, double rx1, double ry1, double rx2, double ry2, Qt::KeyboardModifiers m);
  SubSignalPool selection() const;
protected:
  virtual void paintData(const LayerPainterRequest& lp, QPainter& p, double dotpercm) const;
  void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  XMLMember xml_member(XML_MEMBER_ARGS);
  void xml_polishChild(XML_POLISHCHILD_ARGS);
private:
  void drawRanges(const GraphContentOptions& gc, QPainter& p,
                  const SparseTimeRange& r,
                  double yBase, double minY, double maxY,
                  const QColor& fill, const QColor& border) const;

  SubSignalPool * _subPool;
  bool _subPoolOwner;
  StationList _stations;
  double _minimumGap;

  static uint _tab;
  struct StationRange {
    SparseTimeRange _selected, _available, _overlap;
  };
  QVector<StationRange> _ranges;
};

} // namespace GeopsyGui

#endif // CHRONOGRAMLAYER_H
