/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-03-31
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "XMLSubSignalPool.h"
#include "XMLSignal.h"

namespace GeopsyCore {

/*!
  \class XMLSubSignalPool XMLSubSignalPool.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

const QString XMLSubSignalPool::xmlSubSignalPoolTag="SubPool";

/*!
  Description of constructor still missing
*/  
XMLSubSignalPool::XMLSubSignalPool(const SubSignalPool& subPool)
    : XMLClass()
{
  TRACE;
  int n=subPool.count();
  for(int i=0; i< n ; i++) {
    Signal * sig=subPool.at(i);
    _signals.append(new XMLSignal(sig));
  }
}

XMLSubSignalPool::~XMLSubSignalPool()
{
  TRACE;
  qDeleteAll(_signals);
}

SubSignalPool * XMLSubSignalPool::subPool() const
{
  TRACE;
  SubSignalPool * sub=new SubSignalPool;
  int n=_signals.count();
  for(int i=0; i< n ; i++ ) {
    XMLSignal * sig=_signals.at(i);
    sub->addSignal(sig->signal());
  }
  return sub;
}

void XMLSubSignalPool::xml_writeChildren(XML_WRITECHILDREN_ARGS) const
{
  TRACE;
  static const QString key("index");
  XMLSaveAttributes att;
  QString& value=att.add(key);
  int n=_signals.count();
  for(int i=0; i< n ; i++ ) {
    XMLSignal * sig=_signals.at(i);
    value=QString::number(i);
    sig->xml_save(s, context, att);
  }
}

XMLMember XMLSubSignalPool::xml_member(XML_MEMBER_ARGS)
{
  TRACE;
  Q_UNUSED(attributes)
  Q_UNUSED(context)
  if(tag==XMLSignal::xmlSignalTag) {
    XMLSignal * sig=new XMLSignal();
    _signals.append(sig);
    return XMLMember(sig);
  } else {
    return XMLMember(XMLMember::Unknown);
  }
}

} // namespace GeopsyCore
