/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-06-08
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "GeopsyPluginSettings.h"
#include "GeopsyCoreVersion.h"

namespace GeopsyCore {

  /*!
    \class GeopsyPluginSettings GeopsyPluginSettings.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  GeopsyPluginSettings::GeopsyPluginSettings()
  {
    _reg=&CoreApplication::instance()->settings();
    _reg->beginGroup("Plugins");
    _reg->beginGroup(GEOPSYCORE_VERSION_TYPE);
  }

  bool GeopsyPluginSettings::hasPopular() const
  {
    return _reg->contains("popular");
  }

  QStringList GeopsyPluginSettings::popular() const
  {
    return _reg->value("popular").toStringList();
  }

  void GeopsyPluginSettings::setPopular(const QStringList& l)
  {
    _reg->setValue("popular", l);
  }
} // namespace GeopsyCore

