/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-08-06
**  Copyright: 2010-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "GeopsyCoreInterface.h"
#include "GeopsyCoreVersion.h"

namespace GeopsyCore {

  /*!
    \class GeopsyCoreInterface GeopsyCoreInterface.h
    \brief Abstract interface for all Geopsy plugins

    The constructor of a new plugin is the right place to add custom file formats.
    At the constructor time, the current data base and the signal cache are not initialized.
    Reimplement polish() if you need these two elements to be initialized.
  */

  /*!
    Return a complete description of the plugin. By default, it returns a null string.
  */
  QString GeopsyCoreInterface::description() const
  {
    return QString();
  }

  /*!
    Check if the plugin version is compatible with the current core
  */
  bool GeopsyCoreInterface::isValid() const
  {
    static const Version vRef(GEOPSYCORE_VERSION);
    Version v(interfaceVersion());
    return v.compatible(vRef);
  }

  /*!
    \fn const char * GeopsyCoreInterface::interfaceVersion() const
    Returns the geopsycore version of the plugin (at compile time)
  */

} // namespace GeopsyCore
