/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2002-11-22
**  Copyright: 2002-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GEOPSYCOREENGINE_H
#define GEOPSYCOREENGINE_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"
#include "SignalFile.h"
#include "SignalFileFormat.h"

namespace GeopsyCore {

  class SignalDatabase;
  class GeopsyPlugins;
  class GeopsyPreferences;
  class SubSignalPool;
  class CustomFileFormats;

  class GEOPSYCORE_EXPORT GeopsyCoreEngine : public GlobalObject
  {
    TRANSLATIONS("GeopsyCoreEngine")
  public:
    GeopsyCoreEngine(bool plugins=true, bool debug=false);
    virtual ~GeopsyCoreEngine();

    static GeopsyCoreEngine * instance() {return _self;}

    virtual void beginAddFile(SignalDatabase * db) {Q_UNUSED(db)}
    virtual void endAddFile(SignalDatabase * db) {Q_UNUSED(db)}

    virtual void beginSignalChange(Signal * sig) {Q_UNUSED(sig)}
    virtual void endSignalChange(Signal * sig) {Q_UNUSED(sig)}

    virtual void beginSignalChange(SignalDatabase * db) {Q_UNUSED(db)}
    virtual void endSignalChange(SignalDatabase * db) {Q_UNUSED(db)}

    bool isFileContentKey() const {return _fileContentKey;}
    void setFileContentKey(bool k) {_fileContentKey=k;}

    Cache * cache() {return _cache;}
    GeopsyPreferences * preferences() {return _preferences;}
    GeopsyPlugins * plugins() {return _plugins;}
    SignalDatabase * database(QString path);
    SignalDatabase * defaultDatabase();
    CustomFileFormats * customFileFormats() {return _customFileFormats;}

    void setConsoleProgress(bool s);
    virtual bool useProgress() {return _progress;}
    virtual void setProgressMaximum(SignalDatabase *, int val);
    virtual int progressMaximum(SignalDatabase *) {if(_progress) return _progress->maximum(); else return 0;}
    virtual void setProgressValue(SignalDatabase *, int val) {if(_progress) _progress->setValue(val);}
    virtual int progressValue(SignalDatabase *) {if(_progress) return _progress->value(); else return 0;}
    virtual void increaseProgressValue(SignalDatabase *, int val=1) {if(_progress) _progress->increaseValue(val);}
    virtual void showMessage(SignalDatabase *, QString s);

    virtual void newSignalViewer(const SubSignalPool&) {}
    virtual SignalFileFormat askLoadFormat(const QString& signalFileName);
    virtual bool askRD3LogParameter(int& nSamples, double& sampFreq, double& t0);
  protected:
    static GeopsyCoreEngine * _self;

    GeopsyPreferences * _preferences;
    Cache * _cache;
    QList<SignalDatabase *> _databases;
    bool _fileContentKey;
    CustomFileFormats * _customFileFormats;
    ConsoleProgress * _progress;
    GeopsyPlugins * _plugins;
  };

} // namespace GeopsyCore

#endif // GEOPSYCOREENGINE_H
