/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-10-18
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ParamGroundModel_H
#define ParamGroundModel_H

#include <DinverCore.h>
#include <QGpCoreWave.h>

#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

class ParamProfile;
class ParamLayer;
class GroundParameter;

typedef QList<ParamProfile *> ProfileList;

class DINVERDCCORE_EXPORT ParamGroundModel : public XMLClass
{
  TRANSLATIONS("ParamGroundModel")
public:
  ParamGroundModel();
  ParamGroundModel(const ParamGroundModel& o);
  ParamGroundModel(Seismic1DModel * m);
  virtual ~ParamGroundModel();

  void setCustomConditions(const QString& t) {_customConditions.setText(t);}
  const ParamSpaceScript& customConditions() const {return _customConditions;}

  int nProfiles() const {return _profiles.count();}
  ParamProfile * profile(int index) {return _profiles[index];}
  ParamProfile * find(QString shortName);

  bool toParameters(RealSpace& ps) const;
  void insertLayer(ParamProfile * profile, int at, ParamLayer * layer);
  void addProfile(ParamProfile * profile) {_profiles.append(profile);}
  void removeProfile(ParamProfile * profile);
  void initFinalProfiles();
  void updateFinalProfiles(const GroundParameter * from=0);
  bool isEmpty();
  bool hasGradient() const;

  void setDepthLinks();

  const Point& position() const {return _position;}
  void setPosition(const Point& p) {_position=p;}
protected:
  virtual const QString& xml_tagName() const {return xmlParamGroundModelTag;}
  static const QString xmlParamGroundModelTag;
  virtual void xml_writeProperties(XML_WRITECHILDREN_ARGS) const;
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
  virtual bool xml_polish(XML_POLISH_ARGS);
private:
  ProfileList _profiles;
  ParamSpaceScript _customConditions;

  void resampleProfiles();

  // Position
  Point _position;
};

} // namespace DinverDCCore

#endif // PARAMGROUNDMODEL_H
