/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-06-08
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef XMLVIRTUALPLUGIN_H
#define XMLVIRTUALPLUGIN_H

#include "XMLDinver.h"
#include "DinverCoreDLLExport.h"

namespace DinverCore {

  class DINVERCORE_EXPORT XMLVirtualPlugin : public XMLDinver
  {
  public:
    XMLVirtualPlugin(XMLClass * object, QString pluginTag);
  protected:
    virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
    virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
    virtual XMLMember xml_member(XML_MEMBER_ARGS);
    virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
    virtual void xml_polishChild(XML_POLISHCHILD_ARGS);
  private:
    QString _pluginTag;
    XMLClass * _object;
  };

} // namespace DinverCore

#endif // XMLVIRTUALPLUGIN_H
