/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-12-22
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef NEWMODEL_H
#define NEWMODEL_H

#include "ParentIndex.h"
#include "DinverCoreDLLExport.h"

namespace DinverCore {

  class DINVERCORE_EXPORT NewModel
  {
  public:
    inline NewModel();
    inline ~NewModel();

    void setModelIndex(int i) {_modelIndex=i;}
    void setValidParent(bool v) {_validParent=v;}
    void setParentIndex(ParentIndex * p) {_parentIndex=p;}
    void setValidMisfit(bool v) {_validMisfit=v;}
    void setMisfit(double m) {_misfit=m;}
    void addNavigatorHit(int activeModelIndex) {_navigatorHits.append(activeModelIndex);}

    int modelIndex() const {return _modelIndex;}
    bool isValidParent() const {return _validParent;}
    ParentIndex * parentIndex() const {return _parentIndex;}
    bool isValidMisfit() const {return _validMisfit;}
    double misfit() const {return _misfit;}
    const QVector<int>& navigatorHits() const {return _navigatorHits;}
  private:
    int _modelIndex;
    bool _validMisfit;
    double _misfit;
    bool _validParent;
    ParentIndex * _parentIndex;
    QVector<int> _navigatorHits;
  };

  inline NewModel::NewModel()
  {
    _modelIndex=-1;
    _validParent=false;
    _parentIndex=nullptr;
    _validMisfit=false;
  }

  inline NewModel::~NewModel()
  {
    delete _parentIndex;
  }

} // namespace DinverCore

#endif // NEWMODEL_H
