/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-06-16
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef IMPORTANCESAMPLING_H
#define IMPORTANCESAMPLING_H

#include <QGpCoreTools.h>
#include <QGpCoreMath.h>

#include "DinverCoreDLLExport.h"

namespace DinverCore {

class AbstractForward;
class ModelSet;
class UniqueRandom;
class ReportWriter;

class DINVERCORE_EXPORT ImportanceSampling
{
  TRANSLATIONS("ImportanceSampling")
public:
  ImportanceSampling();
  ~ImportanceSampling();

  bool openReport(const QString& fileName);
  void setSeed(int seed);
  void setForward(AbstractForward * forward);
  bool importModels(QString fileName, bool strict=true);
  void generate(int ns=5000, int nw=2);
private:
  double * scales() const;

  uint _parameterSpaceChecksum;

  ModelSet * _models;
  AbstractForward * _forward;
  Random * _randomGenerator;
  ReportWriter * _report;
};

} // namespace DinverCore

#endif // IMPORTANCESAMPLING_H
