/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-03-23
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ACTIVEMODEL_H
#define ACTIVEMODEL_H

#include <QGpCoreTools.h>
#include "DinverCoreDLLExport.h"

namespace DinverCore {

class DINVERCORE_EXPORT ActiveModel
{
  TRANSLATIONS("ActiveModel")
public:
  inline void operator=(int modelIndex);
  inline void operator=(const ActiveModel& o);

  int modelIndex() const {return _modelIndex;}

  int acceptedCount() const {return _nAccepted;}
  void addAccepted() {_nAccepted++;}

  int rejectedCount() const {return _nRejected;}
  void addRejected() {_nRejected++;}

  bool isQuarantined() const {return _quarantined;}
  void setQuarantined() {_quarantined=true;}

  inline bool giveUp(double ratio) const;

  int navigatorHitCount() const {return _navigatorHitCount;}
  inline void addNavigatorHit();
  int navigatorHitTime() const {return _navigatorHitTime;}
  void setNavigatorHitTime(int n=0) {_navigatorHitTime=n;}

  bool isDying() const {return false;}
  bool isAlive() const {return true;}
  inline void healthCheck();

  static inline bool compareHitCount(const ActiveModel * m1, const ActiveModel * m2);
private:
  int _modelIndex;
  int _nAccepted;
  int _nRejected;
  int _navigatorHitCount;
  int _navigatorHitTime;
  bool _quarantined;
};

inline void ActiveModel::operator=(int modelIndex)
{
  _modelIndex=modelIndex;
  _nAccepted=0;
  _nRejected=0;
  _navigatorHitCount=0;
  _navigatorHitTime=0;
  _quarantined=false;
}

inline void ActiveModel::operator=(const ActiveModel& o)
{
  _modelIndex=o._modelIndex;
  _nAccepted=o._nAccepted;
  _nRejected=o._nRejected;
  _quarantined=o._quarantined;
  _navigatorHitCount=o._navigatorHitCount;
  _navigatorHitTime=o._navigatorHitTime;
}

inline void ActiveModel::healthCheck()
{
  // Negative navigator hit count are always considered as alive.
  /*if(_nNavigatorHits>0) {
    _nNavigatorHits=0;
    _lives++;
  } else if(_nNavigatorHits==0) {
     if(isAlive()) _lives--;
  }*/
}

inline void ActiveModel::addNavigatorHit()
{
  /*if(!alive()) {
    App::log(tr("Back to life\n") );
    _lives++;
  }*/
  _navigatorHitCount++;
}

inline bool ActiveModel::giveUp(double ratio) const
{
  return _nRejected>50 &&
         _nRejected>ratio*(double)(_nRejected+_nAccepted);
}

inline bool ActiveModel::compareHitCount(const ActiveModel * m1, const ActiveModel * m2)
{
  return m1->navigatorHitCount()>m2->navigatorHitCount();
}

} // namespace DinverCore

#endif // ACTIVEMODEL_H
