/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-03-20
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "WaveNumberConverter.h"

namespace ArrayCore {

  /*!
    \class WaveNumberConverter WaveNumberConverter.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  WaveNumberConverter::WaveNumberConverter(double frequency)
  {
    TRACE;
    _frequency=frequency;
    _waveNumberFactor=1.0/(2.0*M_PI*_frequency);
  }

  double WaveNumberConverter::azimuth(const Point2D &k) const
  {
    double a=90.0-Angle::radiansToDegrees(_origin.azimuthTo(k));
    return Angle::canonicalDegrees(a);
  }

} // namespace ArrayCore

