/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-04-13
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SPACTOOL_H
#define SPACTOOL_H

#include "AbstractArrayTool.h"
#include "SPACParameters.h"
#include "SPACResults.h"
#include "SPACTaskManager.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT SPACTool : public AbstractArrayTool
  {
  public:
    SPACTool();
    ~SPACTool();

    virtual bool setSubPool(SubSignalPool *subPool);

    virtual bool setParameters(const AbstractParameters& param);
    inline const SPACParameters * parameters() const;
    inline  SPACParameters * parameters();

    SPACResults * results() const {return static_cast<SPACResults *>(AbstractArrayTool::results());}
  protected:
    virtual QString toolName() {return tr("SPAC Array analysis");}
    virtual TaskManager * createLoop() {return new SPACTaskManager(array());}
  private:
    void autoRings();
  };

  inline const SPACParameters * SPACTool::parameters() const
  {
    return static_cast<const SPACParameters *>(AbstractArrayTool::parameters());
  }

  inline SPACParameters * SPACTool::parameters()
  {
    return static_cast<SPACParameters *>(AbstractArrayTool::parameters());
  }

} // namespace ArrayCore

#endif // SPACTOOL_H

