/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-01-28
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "FKSteeringTwoComponentRayleighFixedEll.h"

namespace ArrayCore {

  /*!
    \class FKSteeringTwoComponentRayleighFixedEll FKSteeringTwoComponentRayleighFixedEll.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  void FKSteeringTwoComponentRayleighFixedEll::init(FKCache * cache, int index, const Point2D& k)
  {
    FKSteeringTwoComponentRayleighFixedEll& s=FKSteeringTwoComponentRayleighFixedEll::cache(cache, index);
    s.resize();
    s.initValue(k);
  }

  void FKSteeringTwoComponentRayleighFixedEll::initValue(const Point2D& k)
  {
    int stationCount=_array->count();
    Complex q, qc;
    for(int i=stationCount-1; i>=0; i--) {
      const Point2D& r=_array->relativePos(i);
      q.setUnitExp(-r.scalarProduct(k));
      qc=conjugate(q);
      _e.at(i, 0)=q;
      _eh.at(0, i)=conjugate(q);
      _e.at(i+stationCount, 0)=q;
      _eh.at(0, i+stationCount)=conjugate(q);
    }
  }

} // namespace ArrayCore

