/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-11-28
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ARRAYTASKMANAGER_H
#define ARRAYTASKMANAGER_H

#include <QGpCoreTools.h>

#include "ArrayCoreDLLExport.h"
#include "ArrayTask.h"

namespace ArrayCore {

  class ArraySelection;
  class ArrayParameters;
  class AbstractArrayResults;

  class ARRAYCORE_EXPORT ArrayTaskManager: public TaskManager
  {
  public:
    ArrayTaskManager(const ArrayStations * array);
    virtual ~ArrayTaskManager();

    const ArraySelection& array() const {return _array;}

    virtual bool setParameters(const ArrayParameters * p);
    const ArrayParameters * parameters() const {return _parameters;}

    void setResults(AbstractArrayResults * res);
    AbstractArrayResults * results() const {return _results;}

    const SparseKeepSignal * keep() const {return _keep;}

    void setTasks();
  protected:
    AbstractTask * createTask(int taskIndex);

    const ArrayParameters * _parameters;
    ArraySelection _array;
    SparseKeepSignal * _keep;
  private:
    bool setTimeLimits();
    void setGlobalKeep();

    AbstractArrayResults * _results;
  };

} // namespace ArrayCore

#endif // ARRAYTASKMANAGER_H

